/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.bumble;

import gregapi.data.CS;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public interface IItemBumbleBee {
    public int bumbleProductCount(ItemStack var1, short var2);

    public ItemStack bumbleProductStack(ItemStack var1, short var2, long var3, int var5);

    public int bumbleProductChance(ItemStack var1, short var2, int var3);

    public ChunkCoordinates bumbleCanProduct(World var1, int var2, int var3, int var4, ItemStack var5, short var6, int var7);

    public ChunkCoordinates bumbleCanProduce(World var1, int var2, int var3, int var4, ItemStack var5, short var6, int var7);

    public byte bumbleType(ItemStack var1);

    public ItemStack bumbleScan(ItemStack var1);

    public ItemStack bumbleKill(ItemStack var1);

    public ItemStack bumbleCrown(ItemStack var1);

    public int bumbleMutateChance(ItemStack var1, short var2);

    public ItemStack bumbleMutate(ItemStack var1, short var2, Random var3);

    public ItemStack bumbleCombine(ItemStack var1, short var2, ItemStack var3, short var4, byte var5, Random var6);

    public ItemStack bumbleDrone(ItemStack var1, short var2);

    public ItemStack bumblePrincess(ItemStack var1, short var2);

    public ItemStack bumbleQueen(ItemStack var1, short var2);

    public ItemStack bumbleDead(ItemStack var1, short var2);

    public ItemStack bumbleDrone_(ItemStack var1, short var2);

    public ItemStack bumblePrincess_(ItemStack var1, short var2);

    public ItemStack bumbleQueen_(ItemStack var1, short var2);

    public ItemStack bumbleDead_(ItemStack var1, short var2);

    public boolean bumbleAttack(ItemStack var1, short var2, EntityLivingBase var3);

    public boolean bumbleEqual(ItemStack var1, short var2, ItemStack var3, short var4);

    public static class Util {
        public static NBTTagCompound getBumbleTag(ItemStack aBumbleBee) {
            NBTTagCompound aNBT = UT.NBT.getOrCreate(aBumbleBee);
            NBTTagCompound rBumbleTag = aNBT.getCompoundTag("gt.bumble");
            if (rBumbleTag == null || rBumbleTag.hasNoTags()) {
                rBumbleTag = Util.getBumbleGenes(CS.RNGSUS);
            }
            aNBT.setTag("gt.bumble", (NBTBase)rBumbleTag);
            return rBumbleTag;
        }

        public static ItemStack setBumbleTag(ItemStack aBumbleBee, NBTTagCompound aBumbleTag) {
            UT.NBT.getOrCreate(aBumbleBee).setTag("gt.bumble", (NBTBase)aBumbleTag);
            return aBumbleBee;
        }

        public static NBTTagCompound getBumbleGenes(ItemStack aBumblePrincess, ItemStack aBumbleDrone, Random aRandom) {
            NBTTagCompound rBumbleTag = UT.NBT.make();
            NBTTagCompound tBumbleTagA = Util.getBumbleTag(aBumblePrincess);
            NBTTagCompound tBumbleTagB = Util.getBumbleTag(aBumbleDrone);
            if (tBumbleTagA == null || tBumbleTagA.hasNoTags()) {
                tBumbleTagA = Util.getBumbleGenes(aRandom);
            }
            if (tBumbleTagB == null || tBumbleTagB.hasNoTags()) {
                tBumbleTagB = Util.getBumbleGenes(aRandom);
            }
            Util.setHumidityMin(rBumbleTag, Util.getHumidityMin(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setHumidityMax(rBumbleTag, Util.getHumidityMax(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setOffspring(rBumbleTag, Util.getOffspring(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setWorkForce(rBumbleTag, Util.getWorkForce(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setAggressiveness(rBumbleTag, Util.getAggressiveness(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setLifeSpan(rBumbleTag, Util.getLifeSpan(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setTemperatureMin(rBumbleTag, Util.getTemperatureMin(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setTemperatureMax(rBumbleTag, Util.getTemperatureMax(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setRainproof(rBumbleTag, Util.getRainproof(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setStormproof(rBumbleTag, Util.getStormproof(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setNightActive(rBumbleTag, Util.getNightActive(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setDayActive(rBumbleTag, Util.getDayActive(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB) || !Util.getNightActive(rBumbleTag));
            Util.setInsideActive(rBumbleTag, Util.getInsideActive(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB));
            Util.setOutsideActive(rBumbleTag, Util.getOutsideActive(aRandom.nextBoolean() ? tBumbleTagA : tBumbleTagB) || !Util.getInsideActive(rBumbleTag));
            return rBumbleTag;
        }

        public static NBTTagCompound getBumbleGenes(Random aRandom) {
            return Util.getBumbleGenes(WD.envTemp(BiomeGenBase.plains), BiomeGenBase.plains, true, aRandom);
        }

        public static NBTTagCompound getBumbleGenes(long aTemperature, BiomeGenBase aBiome, boolean aHasSky, Random aRandom) {
            return Util.getBumbleGenes(aTemperature, aBiome, aHasSky, !CS.BIOMES_DESERT.contains(aBiome.biomeName) && !CS.BIOMES_MESA.contains(aBiome.biomeName), CS.BIOMES_DESERT.contains(aBiome.biomeName) || CS.BIOMES_MESA.contains(aBiome.biomeName), aRandom);
        }

        public static NBTTagCompound getBumbleGenes(long aTemperature, BiomeGenBase aBiome, boolean aHasSky, boolean aDay, boolean aNight, Random aRandom) {
            NBTTagCompound rBumbleTag = UT.NBT.make();
            Util.setHumidityMin(rBumbleTag, aBiome.rainfall - 0.1f - (float)aRandom.nextInt(41) / 100.0f);
            Util.setHumidityMax(rBumbleTag, aBiome.rainfall + 0.1f + (float)aRandom.nextInt(41) / 100.0f);
            Util.setTemperatureMin(rBumbleTag, aTemperature - 15L - (long)aRandom.nextInt(31));
            Util.setTemperatureMax(rBumbleTag, aTemperature + 15L + (long)aRandom.nextInt(31));
            Util.setOffspring(rBumbleTag, 1 + aRandom.nextInt(4));
            Util.setWorkForce(rBumbleTag, 1 + aRandom.nextInt(10000));
            Util.setAggressiveness(rBumbleTag, 100 + aRandom.nextInt(9901));
            Util.setLifeSpan(rBumbleTag, 1200 + aRandom.nextInt(142801));
            Util.setDayActive(rBumbleTag, aDay || !aNight);
            Util.setNightActive(rBumbleTag, aNight || !aDay);
            if (aHasSky) {
                Util.setOutsideActive(rBumbleTag, true);
                if ((float)aRandom.nextInt(10000) < aBiome.rainfall * 10000.0f) {
                    Util.setRainproof(rBumbleTag, true);
                }
                if ((float)aRandom.nextInt(20000) < aBiome.rainfall * 10000.0f) {
                    Util.setStormproof(rBumbleTag, true);
                }
            } else {
                Util.setInsideActive(rBumbleTag, true);
            }
            return rBumbleTag;
        }

        public static void setHumidityMin(NBTTagCompound aBumbleTag, float aHumidity) {
            aBumbleTag.setFloat("minhum", aHumidity < 0.01f ? 0.0f : aHumidity);
        }

        public static void setHumidityMax(NBTTagCompound aBumbleTag, float aHumidity) {
            aBumbleTag.setFloat("maxhum", aHumidity < 0.01f ? 0.01f : aHumidity);
        }

        public static void setTemperatureMin(NBTTagCompound aBumbleTag, long aTemperature) {
            UT.NBT.setNumber(aBumbleTag, "mintemp", aTemperature);
        }

        public static void setTemperatureMax(NBTTagCompound aBumbleTag, long aTemperature) {
            UT.NBT.setNumber(aBumbleTag, "maxtemp", aTemperature);
        }

        public static void setOffspring(NBTTagCompound aBumbleTag, long aOffspring) {
            UT.NBT.setNumber(aBumbleTag, "offspring", UT.Code.bindStack(aOffspring));
        }

        public static void setAggressiveness(NBTTagCompound aBumbleTag, long aAggressiveness) {
            UT.NBT.setNumber(aBumbleTag, "aggro", UT.Code.bind(1L, 10000L, aAggressiveness));
        }

        public static void setWorkForce(NBTTagCompound aBumbleTag, long aWorkForce) {
            UT.NBT.setNumber(aBumbleTag, "work", UT.Code.bind(1L, 10000L, aWorkForce));
        }

        public static void setLifeSpan(NBTTagCompound aBumbleTag, long aLifeSpan) {
            UT.NBT.setNumber(aBumbleTag, "life", UT.Code.bind(1200L, 144000L, aLifeSpan));
        }

        public static void setRainproof(NBTTagCompound aBumbleTag, boolean aRainproof) {
            UT.NBT.setBoolean(aBumbleTag, "rain", aRainproof);
        }

        public static void setStormproof(NBTTagCompound aBumbleTag, boolean aStormproof) {
            UT.NBT.setBoolean(aBumbleTag, "storm", aStormproof);
        }

        public static void setDayActive(NBTTagCompound aBumbleTag, boolean aDayActive) {
            UT.NBT.setBoolean(aBumbleTag, "day", aDayActive);
        }

        public static void setNightActive(NBTTagCompound aBumbleTag, boolean aNightActive) {
            UT.NBT.setBoolean(aBumbleTag, "night", aNightActive);
        }

        public static void setOutsideActive(NBTTagCompound aBumbleTag, boolean aOutsideActive) {
            UT.NBT.setBoolean(aBumbleTag, "outside", aOutsideActive);
        }

        public static void setInsideActive(NBTTagCompound aBumbleTag, boolean aInsideActive) {
            UT.NBT.setBoolean(aBumbleTag, "inside", aInsideActive);
        }

        public static float getHumidityMin(NBTTagCompound aBumbleTag) {
            return Math.max(0.0f, aBumbleTag.getFloat("minhum"));
        }

        public static float getHumidityMax(NBTTagCompound aBumbleTag) {
            return Math.max(0.01f, aBumbleTag.getFloat("maxhum"));
        }

        public static long getTemperatureMin(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getLong("mintemp");
        }

        public static long getTemperatureMax(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getLong("maxtemp");
        }

        public static long getOffspring(NBTTagCompound aBumbleTag) {
            return UT.Code.bindStack(aBumbleTag.getLong("offspring"));
        }

        public static long getAggressiveness(NBTTagCompound aBumbleTag) {
            return UT.Code.bind(100L, 10000L, aBumbleTag.getLong("aggro"));
        }

        public static long getWorkForce(NBTTagCompound aBumbleTag) {
            return UT.Code.bind(1L, 10000L, aBumbleTag.getLong("work"));
        }

        public static long getLifeSpan(NBTTagCompound aBumbleTag) {
            return UT.Code.bind(1200L, 144000L, aBumbleTag.getLong("life"));
        }

        public static boolean getRainproof(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("rain");
        }

        public static boolean getStormproof(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("storm");
        }

        public static boolean getDayActive(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("day");
        }

        public static boolean getNightActive(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("night");
        }

        public static boolean getOutsideActive(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("outside");
        }

        public static boolean getInsideActive(NBTTagCompound aBumbleTag) {
            return aBumbleTag.getBoolean("inside");
        }
    }
}

