/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IArmorApiarist;
import gregapi.GT_API;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemUpdatable;
import gregapi.lang.LanguageHandler;
import gregapi.oredict.OreDictItemData;
import gregapi.util.CR;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import ic2.api.item.IMetalArmor;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.BehaviorProjectileDispense;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.util.EnumHelper;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.IMetalArmor", modid="IC2"), @Optional.Interface(iface="forestry.api.apiculture.IArmorApiarist", modid="Forestry")})
public class ItemArmorBase
extends ItemArmor
implements IItemUpdatable,
IItemGT,
IItemNoGTOverride,
ISpecialArmor,
IMetalArmor,
IArmorApiarist {
    protected IIcon mIcon;
    protected final String mModID;
    protected final String mName;
    protected final String mTooltip;
    public int mEnchantability;
    public boolean mMetalArmor = false;
    public boolean mBeeArmor = false;
    public String mArmorTexture;
    public String mArmorName;

    public ItemArmorBase(String aModID, String aUnlocalized, String aEnglish, String aEnglishTooltip, String aArmorName, int aSlot, int[] aShields, int aDurability, int aDamageReduction, int aEnchantability, boolean aMetalArmor, boolean aBeeArmor, Object ... aRecipe) {
        super(EnumHelper.addArmorMaterial((String)("armor." + aUnlocalized), (int)aDurability, (int[])aShields, (int)aEnchantability), GT_API.api_proxy.addArmor("textures/armor/" + aArmorName), aSlot);
        if (CS.GAPI.mStartedInit) {
            throw new IllegalStateException("Items can only be initialised within preInit!");
        }
        this.mName = aUnlocalized;
        this.mModID = aModID;
        this.mArmorTexture = this.mModID + ":" + "textures/armor/" + aArmorName + "/" + this.armorType + ".png";
        this.mArmorName = aArmorName;
        this.mEnchantability = aEnchantability;
        this.mMetalArmor = aMetalArmor;
        this.mBeeArmor = aBeeArmor;
        LH.add(this.mName, aEnglish);
        this.setMaxDamage(aDurability);
        this.setCreativeTab(CreativeTabs.tabCombat);
        if (UT.Code.stringValid(aEnglishTooltip)) {
            this.mTooltip = this.mName + ".tooltip_main";
            LH.add(this.mTooltip, aEnglishTooltip);
        } else {
            this.mTooltip = null;
        }
        ST.register((Item)this, this.mName);
        if (aRecipe != null && aRecipe.length > 0) {
            CR.shaped(ST.make((Item)this, 1L, 0L), CR.DEF_REV_NCC, aRecipe);
            OreDictItemData tData = OM.data(ST.make((Item)this, 1L, 0L));
            if (tData != null) {
                tData.setUseVanillaDamage();
            }
        }
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        if (this.getMaxDamage() > 0 && !this.getHasSubtypes()) {
            aList.add(aStack.getMaxDamage() - this.getDamage(aStack) + " / " + aStack.getMaxDamage());
        }
        if (this.mTooltip != null) {
            aList.add(LanguageHandler.translate(this.mTooltip, this.mTooltip));
        }
        this.addAdditionalToolTips(aList, aStack, aF3_H);
        while (aList.remove(null)) {
        }
    }

    protected void addAdditionalToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
    }

    public ItemStack onDispense(IBlockSource aSource, ItemStack aStack) {
        EnumFacing enumfacing = BlockDispenser.func_149937_b((int)aSource.getBlockMetadata());
        IPosition iposition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        ItemStack itemstack1 = aStack.splitStack(1);
        BehaviorDefaultDispenseItem.doDispense((World)aSource.getWorld(), (ItemStack)itemstack1, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        return aStack;
    }

    public String getArmorTexture(ItemStack aStack, Entity aEntity, int aSlot, String aType) {
        return this.mArmorTexture;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase aPlayer, ItemStack aStack, DamageSource aSource, double aDamage, int aSlot) {
        return aSource.isUnblockable() ? new ISpecialArmor.ArmorProperties(0, 0.0, 0) : new ISpecialArmor.ArmorProperties(0, (double)this.damageReduceAmount / 25.0, this.getMaxDamage() + 1 - aStack.getItemDamage());
    }

    public int getArmorDisplay(EntityPlayer aPlayer, ItemStack aStack, int aSlot) {
        return this.getArmorMaterial().getDamageReductionAmount(aSlot);
    }

    public void damageArmor(EntityLivingBase aEntity, ItemStack aStack, DamageSource aSource, int aDamage, int aSlot) {
        aStack.damageItem(aDamage, aEntity);
    }

    public boolean isMetalArmor(ItemStack aStack, EntityPlayer aPlayer) {
        return this.mMetalArmor;
    }

    public boolean protectEntity(EntityLivingBase aPlayer, ItemStack aArmor, String aCause, boolean doProtect) {
        return this.mBeeArmor;
    }

    public boolean protectPlayer(EntityPlayer aPlayer, ItemStack aArmor, String aCause, boolean doProtect) {
        return this.mBeeArmor;
    }

    public int getColorFromItemStack(ItemStack aStack, int aRenderpass) {
        return 0xFFFFFF;
    }

    public boolean requiresMultipleRenderPasses() {
        return false;
    }

    public boolean hasColor(ItemStack aStack) {
        return false;
    }

    public int getColor(ItemStack aStack) {
        return -1;
    }

    public void removeColor(ItemStack aStack) {
    }

    public void func_82813_b(ItemStack aStack, int aDyeIndex) {
    }

    public boolean getIsRepairable(ItemStack aStack1, ItemStack aStack2) {
        return false;
    }

    public int getItemEnchantability() {
        return this.mEnchantability;
    }

    public final Item setUnlocalizedName(String aName) {
        return this;
    }

    public String toString() {
        return this.mName;
    }

    public final String getUnlocalizedName() {
        return this.mName;
    }

    public String getUnlocalizedName(ItemStack aStack) {
        return this.getHasSubtypes() ? this.mName + "." + ST.meta_(aStack) : this.mName;
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        return StatCollector.translateToLocal((String)this.getUnlocalizedName(aStack));
    }

    public final boolean getShareTag() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.registerIcon(this.mModID + ":armor/" + this.mArmorName + "/" + this.armorType);
    }

    public IIcon getIconFromDamage(int aMeta) {
        return this.mIcon;
    }

    public IIcon getIconFromDamageForRenderPass(int aMeta, int aRenderpass) {
        return this.mIcon;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.isItemStackUsable(aStack);
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        this.isItemStackUsable(aStack);
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        this.updateItemStack(aStack);
    }

    public boolean doesSneakBypassUse(World aWorld, int aX, int aY, int aZ, EntityPlayer aPlayer) {
        return true;
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        return true;
    }

    public ItemStack make(long aMetaData) {
        return ST.make((Item)this, 1L, aMetaData);
    }

    public ItemStack make(long aAmount, long aMetaData) {
        return ST.make((Item)this, aAmount, aMetaData);
    }

    public static class GT_Item_Dispense
    extends BehaviorProjectileDispense {
        public ItemStack dispenseStack(IBlockSource aSource, ItemStack aStack) {
            return ((ItemArmorBase)aStack.getItem()).onDispense(aSource, aStack);
        }

        protected IProjectile getProjectileEntity(World aWorld, IPosition aPosition) {
            return null;
        }
    }
}

