/*
 * Decompiled with CFR 0.152.
 */
package gregapi.gui;

import gregapi.data.CS;
import gregapi.gui.Slot_Armor;
import gregapi.gui.Slot_Base;
import gregapi.gui.Slot_Holo;
import gregapi.gui.Slot_Normal;
import gregapi.tileentity.ITileEntityInventoryGUI;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerCommon
extends Container {
    public final int mOffset;
    public final int mSlotCount;
    public final int mGUIID;
    public ITileEntityInventoryGUI mTileEntity;
    public InventoryPlayer mInventoryPlayer;

    public ContainerCommon(InventoryPlayer aInventoryPlayer, ITileEntityInventoryGUI aTileEntity) {
        this(aInventoryPlayer, aTileEntity, 0);
    }

    public ContainerCommon(InventoryPlayer aInventoryPlayer, ITileEntityInventoryGUI aTileEntity, int aOffset, int aSlotCount) {
        this(aInventoryPlayer, aTileEntity, 0, aOffset, aSlotCount);
    }

    public ContainerCommon(InventoryPlayer aInventoryPlayer, ITileEntityInventoryGUI aTileEntity, int aGUIID) {
        this(aInventoryPlayer, aTileEntity, aGUIID, 0, aTileEntity.getSizeInventoryGUI());
    }

    public ContainerCommon(InventoryPlayer aInventoryPlayer, ITileEntityInventoryGUI aTileEntity, int aGUIID, int aOffset, int aSlotCount) {
        this.mInventoryPlayer = aInventoryPlayer;
        this.mTileEntity = aTileEntity;
        this.mTileEntity.openInventoryGUI();
        this.mSlotCount = aSlotCount;
        this.mOffset = aOffset;
        this.mGUIID = aGUIID;
        int tOffset = this.addSlots(aInventoryPlayer);
        if (this.doesBindPlayerInventory()) {
            this.bindPlayerInventory(aInventoryPlayer, tOffset);
        }
        this.detectAndSendChanges();
    }

    public int addSlots(InventoryPlayer aPlayerInventory) {
        int i = this.mOffset;
        if (this.useDefaultSlots()) {
            switch (this.mSlotCount) {
                case 1: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    break;
                }
                case 2: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 35));
                    break;
                }
                case 3: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    break;
                }
                case 4: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 44));
                    break;
                }
                case 5: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 35));
                    break;
                }
                case 6: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 44));
                    break;
                }
                case 7: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 35));
                    break;
                }
                case 8: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 44));
                    break;
                }
                case 9: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 53));
                    break;
                }
                case 12: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 35, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 125, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 35, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 125, 44));
                    break;
                }
                case 14: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 44));
                    break;
                }
                case 15: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 53));
                    break;
                }
                case 16: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 53, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 71, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 89, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 107, 62));
                    break;
                }
                case 18: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 44));
                    break;
                }
                case 27: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 17));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 35));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 53));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 53));
                    break;
                }
                case 36: {
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 8));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 26));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 44));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 8, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 26, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 44, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 62, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 80, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 98, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 116, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 134, 62));
                    this.addSlotToContainer(new Slot_Normal(this.mTileEntity, i++, 152, 62));
                }
            }
        }
        return 84;
    }

    public boolean useDefaultSlots() {
        return false;
    }

    public int getSlotCount() {
        return this.useDefaultSlots() ? this.mSlotCount : 0;
    }

    protected final int getAllSlotCount() {
        return this.inventorySlots != null ? (this.doesBindPlayerInventory() ? this.inventorySlots.size() - 36 : this.inventorySlots.size()) : this.getSlotCount();
    }

    public int getStartIndex() {
        return 0;
    }

    public int getShiftClickStartIndex() {
        return this.getStartIndex();
    }

    public int getShiftClickSlotCount() {
        return this.useDefaultSlots() ? this.mSlotCount : 0;
    }

    public boolean doesBindPlayerInventory() {
        return true;
    }

    public boolean canInteractWith(EntityPlayer aPlayer) {
        return this.mTileEntity.isUseableByPlayerGUI(aPlayer);
    }

    protected void bindPlayerInventory(InventoryPlayer aInventoryPlayer, int aOffset) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlotToContainer(new Slot((IInventory)aInventoryPlayer, j + i * 9 + 9, 8 + j * 18, aOffset + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlotToContainer(new Slot((IInventory)aInventoryPlayer, i, 8 + i * 18, aOffset + 58));
        }
    }

    public ItemStack slotClick(int aIndex, int aMouse, int aShift, EntityPlayer aPlayer) {
        this.mTileEntity.markDirtyGUI();
        Slot aSlot = aIndex >= 0 && aIndex < this.inventorySlots.size() ? (Slot)this.inventorySlots.get(aIndex) : null;
        try {
            if (aSlot instanceof Slot_Base && this.mTileEntity.interceptClick(this.mGUIID, (Slot_Base)aSlot, aIndex, aSlot.getSlotIndex(), aPlayer, aShift == 1, aMouse != 0, aMouse, aShift)) {
                ItemStack rStack = this.mTileEntity.slotClick(this.mGUIID, (Slot_Base)aSlot, aIndex, aSlot.getSlotIndex(), aPlayer, aShift == 1, aMouse != 0, aMouse, aShift);
                this.detectAndSendChanges();
                return rStack;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            return null;
        }
        if (aIndex >= 0) {
            if (aSlot == null || aSlot instanceof Slot_Holo) {
                return null;
            }
            if (!(aSlot instanceof Slot_Armor || aIndex >= this.getAllSlotCount() || aIndex >= this.getStartIndex() && aIndex < this.getStartIndex() + this.getSlotCount())) {
                return null;
            }
        }
        ItemStack rStack = null;
        try {
            rStack = super.slotClick(aIndex, aMouse, aShift, aPlayer);
            this.detectAndSendChanges();
            return rStack;
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            InventoryPlayer aPlayerInventory = aPlayer.inventory;
            if (!(aShift != 0 && aShift != 1 || aMouse != 0 && aMouse != 1)) {
                if (aIndex == -999) {
                    if (aPlayerInventory.getItemStack() != null && aIndex == -999) {
                        if (aMouse == 0) {
                            aPlayer.dropPlayerItemWithRandomChoice(aPlayerInventory.getItemStack(), true);
                            aPlayerInventory.setItemStack(null);
                        }
                        if (aMouse == 1) {
                            aPlayer.dropPlayerItemWithRandomChoice(aPlayerInventory.getItemStack().splitStack(1), true);
                            if (aPlayerInventory.getItemStack().stackSize == 0) {
                                aPlayerInventory.setItemStack(null);
                            }
                        }
                    }
                } else if (aShift == 1) {
                    ItemStack tTempStack;
                    if (aSlot != null && aSlot.canTakeStack(aPlayer) && (tTempStack = this.transferStackInSlot(aPlayer, aIndex)) != null) {
                        rStack = ST.copy(tTempStack);
                        if (aSlot.getStack() != null && aSlot.getStack().getItem() == tTempStack.getItem()) {
                            this.slotClick(aIndex, aMouse, aShift, aPlayer);
                        }
                    }
                } else {
                    if (aIndex < 0) {
                        this.detectAndSendChanges();
                        return null;
                    }
                    if (aSlot != null) {
                        ItemStack tTempStack = aSlot.getStack();
                        ItemStack tHeldStack = aPlayerInventory.getItemStack();
                        if (tTempStack != null) {
                            rStack = ST.copy(tTempStack);
                        }
                        if (tTempStack == null) {
                            if (tHeldStack != null && aSlot.isItemValid(tHeldStack)) {
                                int tTempStackSize;
                                int n = tTempStackSize = aMouse == 0 ? tHeldStack.stackSize : 1;
                                if (tTempStackSize > aSlot.getSlotStackLimit()) {
                                    tTempStackSize = aSlot.getSlotStackLimit();
                                }
                                aSlot.putStack(tHeldStack.splitStack(tTempStackSize));
                                if (tHeldStack.stackSize == 0) {
                                    aPlayerInventory.setItemStack(null);
                                }
                            }
                        } else if (aSlot.canTakeStack(aPlayer)) {
                            int tTempStackSize;
                            if (tHeldStack == null) {
                                int tTempStackSize2 = aMouse == 0 ? tTempStack.stackSize : (tTempStack.stackSize + 1) / 2;
                                ItemStack aHoldStack = aSlot.decrStackSize(tTempStackSize2);
                                aPlayerInventory.setItemStack(aHoldStack);
                                if (tTempStack.stackSize == 0) {
                                    aSlot.putStack(null);
                                }
                                aSlot.onPickupFromSlot(aPlayer, aPlayerInventory.getItemStack());
                            } else if (aSlot.isItemValid(tHeldStack)) {
                                if (tTempStack.getItem() == tHeldStack.getItem() && tTempStack.getItemDamage() == tHeldStack.getItemDamage() && ItemStack.areItemStackTagsEqual((ItemStack)tTempStack, (ItemStack)tHeldStack)) {
                                    int tTempStackSize3;
                                    int n = tTempStackSize3 = aMouse == 0 ? tHeldStack.stackSize : 1;
                                    if (tTempStackSize3 > aSlot.getSlotStackLimit() - tTempStack.stackSize) {
                                        tTempStackSize3 = aSlot.getSlotStackLimit() - tTempStack.stackSize;
                                    }
                                    if (tTempStackSize3 > tHeldStack.getMaxStackSize() - tTempStack.stackSize) {
                                        tTempStackSize3 = tHeldStack.getMaxStackSize() - tTempStack.stackSize;
                                    }
                                    tHeldStack.splitStack(tTempStackSize3);
                                    if (tHeldStack.stackSize == 0) {
                                        aPlayerInventory.setItemStack(null);
                                    }
                                    tTempStack.stackSize += tTempStackSize3;
                                } else if (tHeldStack.stackSize <= aSlot.getSlotStackLimit()) {
                                    aSlot.putStack(tHeldStack);
                                    aPlayerInventory.setItemStack(tTempStack);
                                }
                            } else if (tTempStack.getItem() == tHeldStack.getItem() && tHeldStack.getMaxStackSize() > 1 && (!tTempStack.getHasSubtypes() || tTempStack.getItemDamage() == tHeldStack.getItemDamage()) && ItemStack.areItemStackTagsEqual((ItemStack)tTempStack, (ItemStack)tHeldStack) && (tTempStackSize = tTempStack.stackSize) > 0 && tTempStackSize + tHeldStack.stackSize <= tHeldStack.getMaxStackSize()) {
                                tHeldStack.stackSize += tTempStackSize;
                                tTempStack = aSlot.decrStackSize(tTempStackSize);
                                if (tTempStack.stackSize == 0) {
                                    aSlot.putStack(null);
                                }
                                aSlot.onPickupFromSlot(aPlayer, aPlayerInventory.getItemStack());
                            }
                        }
                        aSlot.onSlotChanged();
                    }
                }
            } else if (aShift == 2 && aMouse >= 0 && aMouse < 9) {
                if (aSlot.canTakeStack(aPlayer)) {
                    ItemStack tTempStack = aPlayerInventory.getStackInSlot(aMouse);
                    boolean var9 = tTempStack == null || aSlot.inventory == aPlayerInventory && aSlot.isItemValid(tTempStack);
                    int tTempStackSize = -1;
                    if (!var9) {
                        tTempStackSize = aPlayerInventory.getFirstEmptyStack();
                        var9 |= tTempStackSize > -1;
                    }
                    if (aSlot.getHasStack() && var9) {
                        ItemStack aHoldStack = aSlot.getStack();
                        aPlayerInventory.setInventorySlotContents(aMouse, aHoldStack);
                        if (!(aSlot.inventory == aPlayerInventory && aSlot.isItemValid(tTempStack) || tTempStack == null)) {
                            if (tTempStackSize > -1) {
                                aPlayerInventory.addItemStackToInventory(tTempStack);
                                aSlot.decrStackSize(aHoldStack.stackSize);
                                aSlot.putStack(null);
                                aSlot.onPickupFromSlot(aPlayer, aHoldStack);
                            }
                        } else {
                            aSlot.decrStackSize(aHoldStack.stackSize);
                            aSlot.putStack(tTempStack);
                            aSlot.onPickupFromSlot(aPlayer, aHoldStack);
                        }
                    } else if (!aSlot.getHasStack() && tTempStack != null && aSlot.isItemValid(tTempStack)) {
                        aPlayerInventory.setInventorySlotContents(aMouse, null);
                        aSlot.putStack(tTempStack);
                    }
                }
            } else if (aShift == 3 && UT.Entities.hasInfiniteItems(aPlayer) && aPlayerInventory.getItemStack() == null && aIndex >= 0 && aSlot != null && aSlot.getHasStack()) {
                ItemStack tTempStack = ST.copy(aSlot.getStack());
                tTempStack.stackSize = tTempStack.getMaxStackSize();
                aPlayerInventory.setItemStack(tTempStack);
            }
            this.detectAndSendChanges();
            return rStack;
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer aPlayer, int aIndex) {
        ItemStack rStack = null;
        Slot tSlot = (Slot)this.inventorySlots.get(aIndex);
        this.mTileEntity.markDirtyGUI();
        if (this.getSlotCount() > 0 && tSlot != null && tSlot.getHasStack() && !(tSlot instanceof Slot_Holo)) {
            ItemStack tStack = tSlot.getStack();
            rStack = ST.copy(tStack);
            if (aIndex < this.getAllSlotCount() ? this.doesBindPlayerInventory() && !this.mergeItemStack(tStack, this.getAllSlotCount(), this.getAllSlotCount() + 36, true) : !this.mergeItemStack(tStack, this.getShiftClickStartIndex(), this.getShiftClickStartIndex() + this.getShiftClickSlotCount(), false)) {
                return null;
            }
            if (tStack.stackSize == 0) {
                tSlot.putStack(null);
            } else {
                tSlot.onSlotChanged();
            }
        }
        return rStack;
    }

    protected boolean mergeItemStack(ItemStack aStack, int aStartIndex, int aSlotCount, boolean aReverse) {
        Slot tSlot;
        if (ST.meta(aStack) == Short.MAX_VALUE) {
            return false;
        }
        boolean rSuccess = false;
        int tIndex = aReverse ? aSlotCount - 1 : aStartIndex;
        this.mTileEntity.markDirtyGUI();
        if (aStack.isStackable()) {
            while (aStack.stackSize > 0 && (aReverse ? tIndex >= aStartIndex : tIndex < aSlotCount)) {
                tSlot = (Slot)this.inventorySlots.get(tIndex);
                int tLimit = Math.min(aStack.getMaxStackSize(), tSlot.getSlotStackLimit());
                ItemStack tStack = tSlot.getStack();
                if (!(tSlot instanceof Slot_Holo) && tSlot.isItemValid(aStack) && ST.meta(tStack) != Short.MAX_VALUE && ST.equal(aStack, tStack)) {
                    int tSize = tStack.stackSize + aStack.stackSize;
                    if (tSize <= tLimit) {
                        aStack.stackSize = 0;
                        tStack.stackSize = tSize;
                        tSlot.onSlotChanged();
                        rSuccess = true;
                    } else if (tStack.stackSize < tLimit) {
                        aStack.stackSize -= tLimit - tStack.stackSize;
                        tStack.stackSize = tLimit;
                        tSlot.onSlotChanged();
                        rSuccess = true;
                    }
                }
                if (aReverse) {
                    --tIndex;
                    continue;
                }
                ++tIndex;
            }
        }
        if (aStack.stackSize > 0) {
            tIndex = aReverse ? aSlotCount - 1 : aStartIndex;
            while (aReverse ? tIndex >= aStartIndex : tIndex < aSlotCount) {
                tSlot = (Slot)this.inventorySlots.get(tIndex);
                if (!(tSlot instanceof Slot_Holo) && tSlot.isItemValid(aStack) && tSlot.getStack() == null) {
                    ItemStack tStack = ST.amount(Math.min(aStack.stackSize, Math.min(aStack.getMaxStackSize(), tSlot.getSlotStackLimit())), aStack);
                    tSlot.putStack(tStack);
                    tSlot.onSlotChanged();
                    aStack.stackSize -= tStack.stackSize;
                    rSuccess = true;
                    if (aStack.stackSize <= 0) break;
                }
                if (aReverse) {
                    --tIndex;
                    continue;
                }
                ++tIndex;
            }
        }
        return rSuccess;
    }

    protected Slot addSlotToContainer(Slot aSlot) {
        if (aSlot == null) {
            return null;
        }
        aSlot.slotNumber = this.inventorySlots.size();
        this.inventorySlots.add(aSlot);
        this.inventoryItemStacks.add(null);
        return aSlot;
    }

    public void addCraftingToCrafters(ICrafting par1ICrafting) {
        try {
            super.addCraftingToCrafters(par1ICrafting);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public List<ItemStack> getInventory() {
        try {
            return super.getInventory();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
            return null;
        }
    }

    public void removeCraftingFromCrafters(ICrafting aCrafting) {
        try {
            super.removeCraftingFromCrafters(aCrafting);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void detectAndSendChanges() {
        try {
            if (this.mTileEntity.needsToSyncEverything()) {
                for (int i = 0; i < this.inventorySlots.size(); ++i) {
                    ItemStack tStack = ST.copy(((Slot)this.inventorySlots.get(i)).getStack());
                    this.inventoryItemStacks.set(i, tStack);
                    for (int j = 0; j < this.crafters.size(); ++j) {
                        ((ICrafting)this.crafters.get(j)).sendSlotContents((Container)this, i, tStack);
                    }
                }
            } else {
                for (int i = 0; i < this.inventorySlots.size(); ++i) {
                    ItemStack tStack = ((Slot)this.inventorySlots.get(i)).getStack();
                    if (ST.identical(tStack, (ItemStack)this.inventoryItemStacks.get(i))) continue;
                    tStack = ST.copy(tStack);
                    this.inventoryItemStacks.set(i, tStack);
                    for (int j = 0; j < this.crafters.size(); ++j) {
                        ((ICrafting)this.crafters.get(j)).sendSlotContents((Container)this, i, tStack);
                    }
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public boolean enchantItem(EntityPlayer par1EntityPlayer, int par2) {
        return false;
    }

    public Slot getSlotFromInventory(IInventory aInventory, int aIndex) {
        try {
            for (int j = 0; j < this.inventorySlots.size(); ++j) {
                Slot slot = (Slot)this.inventorySlots.get(j);
                if (!slot.isSlotInInventory(aInventory, aIndex)) continue;
                return slot;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        return null;
    }

    public Slot getSlot(int aIndex) {
        try {
            if (aIndex < this.inventorySlots.size()) {
                return (Slot)this.inventorySlots.get(aIndex);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        return null;
    }

    public boolean func_94530_a(ItemStack aStack, Slot aSlot) {
        return true;
    }

    protected void retrySlotClick(int aIndex, int aMouse, boolean aUnknown, EntityPlayer aPlayer) {
        try {
            this.slotClick(aIndex, aMouse, 1, aPlayer);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void onContainerClosed(EntityPlayer aPlayer) {
        try {
            this.mTileEntity.closeInventoryGUI();
            InventoryPlayer tPlayerInventory = aPlayer.inventory;
            for (ItemStack tStack : tPlayerInventory.mainInventory) {
                ST.check((Entity)aPlayer, tStack);
            }
            for (ItemStack tStack : tPlayerInventory.armorInventory) {
                ST.check((Entity)aPlayer, tStack);
            }
            if (tPlayerInventory.getItemStack() != null) {
                ST.check((Entity)aPlayer, tPlayerInventory.getItemStack());
                aPlayer.dropPlayerItemWithRandomChoice(tPlayerInventory.getItemStack(), false);
                tPlayerInventory.setItemStack(null);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void onCraftMatrixChanged(IInventory aInventory) {
        this.detectAndSendChanges();
    }

    public void putStackInSlot(int aIndex, ItemStack aStack) {
        try {
            this.getSlot(aIndex).putStack(aStack);
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void putStacksInSlots(ItemStack[] aStacks) {
        try {
            for (int i = 0; i < aStacks.length; ++i) {
                this.getSlot(i).putStack(aStacks[i]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
    }

    public void updateProgressBar(int aIndex, int aValue) {
    }

    public short getNextTransactionID(InventoryPlayer aPlayerInventory) {
        return super.getNextTransactionID(aPlayerInventory);
    }

    public boolean isPlayerNotUsingContainer(EntityPlayer aPlayer) {
        return super.isPlayerNotUsingContainer(aPlayer);
    }

    public void setPlayerIsPresent(EntityPlayer aPlayer, boolean aPresent) {
        super.setPlayerIsPresent(aPlayer, aPresent);
    }

    public boolean canDragIntoSlot(Slot aSlot) {
        return true;
    }
}

