/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.ITileEntityItemPipe;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CoverFilterItem
extends AbstractCoverAttachment {
    public static final ITexture sTextureInverted = BlockTextureDefault.get("machines/covers/filteritem/inverted");
    public static final ITexture sTextureNormal = BlockTextureDefault.get("machines/covers/filteritem/normal");

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        ItemStack tStack = ST.load(aStack.getTagCompound(), "gt.filter.item");
        if (ST.valid(tStack)) {
            try {
                aList.add(LH.Chat.CYAN + tStack.getDisplayName());
            }
            catch (Throwable e) {
                aList.add(LH.Chat.BLINKING_RED + "ERROR, CANNOT DISPLAY ITEM NAME");
            }
        }
        aList.add(LH.Chat.ORANGE + "Not NBT sensitive!");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aCoverSide, (short)(aData.mVisuals[aCoverSide] == 0 ? 1 : 0));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Whitelist Filter" : "Blacklist Filter");
            }
            return 1000L;
        }
        if (aTool.equals("softhammer")) {
            if (aData.mNBTs[aCoverSide] != null) {
                aData.mNBTs[aCoverSide].removeTag("gt.filter.item");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Whitelist Filter" : "Blacklist Filter");
                if (aData.mNBTs[aCoverSide] == null) {
                    aChatReturn.add("Filter is empty!");
                    aData.mNBTs[aCoverSide] = null;
                } else {
                    ItemStack tStack = ST.load(aData.mNBTs[aCoverSide], "gt.filter.item");
                    if (ST.invalid(tStack)) {
                        aChatReturn.add("Filter is empty!");
                        aData.mNBTs[aCoverSide] = null;
                    } else {
                        aChatReturn.add("Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + (ST.meta_(tStack) == Short.MAX_VALUE ? LH.Chat.GREEN + "Wildcard" : LH.Chat.CYAN + ST.meta_(tStack)));
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        ItemStack tStack;
        if (aPlayer instanceof EntityPlayer && aData.mTileEntity.isServerSide() && ST.valid(tStack = ST.make(((EntityPlayer)aPlayer).getCurrentEquippedItem(), null, null))) {
            ItemStack tFilter = ST.load(aData.mNBTs[aCoverSide], "gt.filter.item");
            if (ST.invalid(tFilter)) {
                aData.mNBTs[aCoverSide] = ST.save("gt.filter.item", ST.make(ST.item_(tStack), 1L, (long)ST.meta_(tStack)));
                UT.Sounds.send("random.click", aData.mTileEntity);
                UT.Entities.sendchat((Object)aPlayer, "Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack));
            } else if (ST.equal(tFilter, tStack, true)) {
                if (ST.meta_(tFilter) == Short.MAX_VALUE) {
                    aData.mNBTs[aCoverSide] = ST.save("gt.filter.item", ST.make(ST.item_(tStack), 1L, (long)ST.meta_(tStack)));
                    UT.Sounds.send("random.click", aData.mTileEntity);
                    UT.Entities.sendchat((Object)aPlayer, "Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.CYAN + ST.meta_(tStack));
                } else {
                    aData.mNBTs[aCoverSide] = ST.save("gt.filter.item", ST.make(ST.item_(tStack), 1L, 32767L));
                    UT.Sounds.send("random.click", aData.mTileEntity);
                    UT.Entities.sendchat((Object)aPlayer, "Filters for: " + LH.Chat.CYAN + ST.regName(tStack) + LH.Chat.GRAY + " ; " + LH.Chat.GREEN + "Wildcard");
                }
            }
        }
        return true;
    }

    @Override
    public boolean interceptItemInsert(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        if (aCoverSide != aSide) {
            return false;
        }
        if (aData.mStopped) {
            return true;
        }
        if (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.item")) {
            return aData.mVisuals[aCoverSide] == 0;
        }
        return aData.mVisuals[aCoverSide] == 0 != ST.equal(ST.load(aData.mNBTs[aCoverSide], "gt.filter.item"), aStack, true);
    }

    @Override
    public boolean interceptItemExtract(byte aCoverSide, CoverData aData, int aSlot, ItemStack aStack, byte aSide) {
        if (aCoverSide != aSide) {
            return false;
        }
        if (aData.mStopped) {
            return true;
        }
        if (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.item")) {
            return aData.mVisuals[aCoverSide] == 0;
        }
        return aData.mVisuals[aCoverSide] == 0 != ST.equal(ST.load(aData.mNBTs[aCoverSide], "gt.filter.item"), aStack, true);
    }

    @Override
    public boolean interceptConnect(byte aCoverSide, CoverData aData) {
        boolean rIntercept;
        boolean bl = rIntercept = aData.mTileEntity instanceof ITileEntityItemPipe && aData.mTileEntity.getAdjacentTileEntity((byte)aCoverSide).mTileEntity instanceof ITileEntityItemPipe;
        if (rIntercept) {
            ((ITileEntityItemPipe)((Object)aData.mTileEntity)).disconnect(aCoverSide, true);
        }
        return rIntercept;
    }

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return aData.mTileEntity instanceof ITileEntityItemPipe && aData.mTileEntity.getAdjacentTileEntity((byte)aCoverSide).mTileEntity instanceof ITileEntityItemPipe;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return CS.ALONG_AXIS[aCoverSide][aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted) : BACKGROUND_COVER;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }
}

