/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.ITexture;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CoverFilterFluid
extends AbstractCoverAttachment {
    public static final ITexture sTextureInverted = BlockTextureDefault.get("machines/covers/filterfluid/inverted");
    public static final ITexture sTextureNormal = BlockTextureDefault.get("machines/covers/filterfluid/normal");

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        FluidStack tFluid = FL.load(aStack.getTagCompound(), "gt.filter.fluid");
        if (tFluid != null && tFluid.getFluid() != null) {
            aList.add(LH.Chat.CYAN + FL.name(tFluid, true));
        }
        aList.add(LH.Chat.ORANGE + "Not NBT sensitive!");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("screwdriver")) {
            aData.visual(aCoverSide, (short)(aData.mVisuals[aCoverSide] == 0 ? 1 : 0));
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Whitelist Filter" : "Blacklist Filter");
            }
            return 1000L;
        }
        if (aTool.equals("softhammer")) {
            if (aData.mNBTs[aCoverSide] != null) {
                aData.mNBTs[aCoverSide].removeTag("gt.filter.fluid");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(aData.mVisuals[aCoverSide] == 0 ? "Whitelist Filter" : "Blacklist Filter");
                if (aData.mNBTs[aCoverSide] == null) {
                    aChatReturn.add("Filter is empty!");
                    aData.mNBTs[aCoverSide] = null;
                } else {
                    FluidStack tFluid = FL.load(aData.mNBTs[aCoverSide], "gt.filter.fluid");
                    if (tFluid == null) {
                        aChatReturn.add("Filter is empty!");
                        aData.mNBTs[aCoverSide] = null;
                    } else {
                        aChatReturn.add("Filters for: " + LH.Chat.CYAN + tFluid.getFluid().getName());
                    }
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        ItemStack tStack;
        if (aPlayer instanceof EntityPlayer && aData.mTileEntity.isServerSide() && (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.fluid")) && ST.valid(tStack = ((EntityPlayer)aPlayer).getCurrentEquippedItem())) {
            OreDictItemData tData;
            FluidStack tFluid = FL.getFluid(tStack, true);
            if (tFluid == null && (tData = OM.anyassociation_(tStack)) != null && tData.mPrefix.contains(TD.Prefix.IS_CONTAINER) && !tData.mPrefix.contains(TD.Prefix.IS_CRATE)) {
                tFluid = tData.mMaterial.mMaterial.fluid(648648000L, true);
            }
            if (FL.valid(tFluid)) {
                aData.mNBTs[aCoverSide] = FL.save(null, "gt.filter.fluid", tFluid);
                UT.Sounds.send("random.click", aData.mTileEntity);
                UT.Entities.sendchat((Object)aPlayer, "Filters for: " + LH.Chat.CYAN + tFluid.getFluid().getName());
            }
        }
        return true;
    }

    @Override
    public boolean interceptFluidFill(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToFill) {
        if (aCoverSide != aSide) {
            return false;
        }
        if (aData.mStopped || aFluidToFill == null) {
            return true;
        }
        if (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.fluid")) {
            return aData.mVisuals[aCoverSide] == 0;
        }
        return aData.mVisuals[aCoverSide] == 0 != FL.equal(FL.load(aData.mNBTs[aCoverSide], "gt.filter.fluid"), aFluidToFill, true);
    }

    @Override
    public boolean interceptFluidDrain(byte aCoverSide, CoverData aData, byte aSide, FluidStack aFluidToDrain) {
        if (aCoverSide != aSide) {
            return false;
        }
        if (aData.mStopped || aFluidToDrain == null) {
            return true;
        }
        if (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].hasKey("gt.filter.fluid")) {
            return aData.mVisuals[aCoverSide] == 0;
        }
        return aData.mVisuals[aCoverSide] == 0 != FL.equal(FL.load(aData.mNBTs[aCoverSide], "gt.filter.fluid"), aFluidToDrain, true);
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return CS.ALONG_AXIS[aCoverSide][aTextureSide] ? BlockTextureMulti.get(BACKGROUND_COVER, aData.mVisuals[aCoverSide] == 0 ? sTextureNormal : sTextureInverted) : BACKGROUND_COVER;
    }

    @Override
    public ITexture getCoverTextureHolder(byte aCoverSide, CoverData aData, byte aTextureSide) {
        return BACKGROUND_COVER;
    }

    @Override
    public boolean needsVisualsSaved(byte aCoverSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }
}

