/*
 * Decompiled with CFR 0.152.
 */
package gregapi.code;

import gregapi.code.ICondition;
import gregapi.code.ITagDataContainer;
import gregapi.data.LH;
import gregapi.oredict.OreDictMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TagData
implements ICondition<ITagDataContainer> {
    private static final List<TagData> TAGS_INTERNAL = new ArrayList<TagData>();
    public static final List<TagData> TAGS = new ArrayList<TagData>();
    public final int mTagID;
    public final String mName;
    public String mChatFormat = "";
    public final ICondition<OreDictMaterial> NOT = new ICondition.Not<ITagDataContainer>(this);
    public final List<TagData> AS_LIST = Collections.unmodifiableList(Arrays.asList(this));

    private TagData(String aName) {
        this.mTagID = TAGS_INTERNAL.size();
        this.mName = aName;
        TAGS_INTERNAL.add(this);
        TAGS.add(this);
    }

    public static TagData createTagData(String aName, String aLocalShort, String aLocalLong, String aChatFormat) {
        TagData rTagData = TagData.createTagData(aName, aLocalShort, aLocalLong);
        rTagData.mChatFormat = aChatFormat;
        return rTagData;
    }

    public static TagData createTagData(String aName, String aLocalShort, String aLocalLong) {
        TagData rTagData = TagData.createTagData(aName);
        LH.add(rTagData.getTranslatableNameShort(), aLocalShort);
        LH.add(rTagData.getTranslatableNameLong(), aLocalLong);
        return rTagData;
    }

    public static TagData createTagData(String aName, String aLocal) {
        return TagData.createTagData(aName, aLocal, aLocal);
    }

    public static TagData createTagData(String aName) {
        aName = aName.toUpperCase();
        for (TagData tSubTag : TAGS_INTERNAL) {
            if (!tSubTag.mName.equals(aName)) continue;
            return tSubTag;
        }
        return new TagData(aName);
    }

    public String getTranslatableNameLong() {
        return "gt.td.long." + this.mName.toLowerCase();
    }

    public String getLocalisedNameLong() {
        return LH.get(this.getTranslatableNameLong(), this.mName);
    }

    public String getLocalisedChatNameLong() {
        return this.getChatFormat() + this.getLocalisedNameLong();
    }

    public String getTranslatableNameShort() {
        return "gt.td.short." + this.mName.toLowerCase();
    }

    public String getLocalisedNameShort() {
        return LH.get(this.getTranslatableNameShort(), this.mName);
    }

    public String getLocalisedChatNameShort() {
        return this.getChatFormat() + this.getLocalisedNameShort();
    }

    public String getChatFormat() {
        return this.mChatFormat;
    }

    public String toString() {
        return this.mName;
    }

    @Override
    public boolean isTrue(ITagDataContainer aObject) {
        return aObject.contains(this);
    }

    public boolean equals(Object aObject) {
        return aObject instanceof TagData && ((TagData)aObject).mTagID == this.mTagID;
    }

    public int hashCode() {
        return this.mTagID;
    }
}

