/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.prefixblock;

import cpw.mods.fml.common.Optional;
import gregapi.block.prefixblock.PrefixBlock;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.item.CreativeTab;
import gregapi.item.IItemGT;
import gregapi.item.IItemNoGTOverride;
import gregapi.item.IItemUpdatable;
import gregapi.item.IPrefixItem;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictPrefix;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.item.IFlowerPlaceable;
import vazkii.botania.api.subtile.SubTileEntity;

@Optional.InterfaceList(value={@Optional.Interface(iface="vazkii.botania.api.item.IFlowerPlaceable", modid="Botania")})
public class PrefixBlockItem
extends ItemBlock
implements IItemUpdatable,
IPrefixItem,
IItemGT,
IItemNoGTOverride,
IFlowerPlaceable {
    public final PrefixBlock mBlock;

    public PrefixBlockItem(Block aBlock) {
        super(aBlock);
        this.setMaxDamage(0);
        this.setHasSubtypes(true);
        this.mBlock = (PrefixBlock)aBlock;
        this.mBlock.mPrefix.mRegisteredPrefixItems.add(this);
        if ((CS.SHOW_HIDDEN_PREFIXES || !this.mBlock.mPrefix.contains(TD.Creative.HIDDEN)) && (CS.SHOW_ORE_BLOCK_PREFIXES || "gt.meta.ore.normal.default".equalsIgnoreCase(this.mBlock.mNameInternal) || !this.mBlock.mPrefix.contains(TD.Prefix.ORE) || this.mBlock.mPrefix.contains(TD.Prefix.STORAGE_BASED))) {
            if (this.mBlock.mPrefix.mCreativeTab == null) {
                this.mBlock.mPrefix.mCreativeTab = new CreativeTab(this.mBlock.mPrefix.mNameInternal, this.mBlock.mPrefix.mNameCategory, (Item)this, Short.MAX_VALUE);
            }
            this.mBlock.setCreativeTab(this.mBlock.mPrefix.mCreativeTab);
            this.setCreativeTab(this.mBlock.mPrefix.mCreativeTab);
        } else {
            this.mBlock.setCreativeTab(CreativeTabs.tabBlock);
            this.setCreativeTab(CreativeTabs.tabBlock);
        }
    }

    public void getSubItems(Item var1, CreativeTabs aCreativeTab, List aList) {
        if (!(this.mBlock.mHidden || !CS.SHOW_HIDDEN_PREFIXES && this.mBlock.mPrefix.contains(TD.Creative.HIDDEN) || !CS.SHOW_ORE_BLOCK_PREFIXES && this.mBlock != CS.BlocksGT.ore && this.mBlock.mPrefix.contains(TD.Prefix.ORE) && !this.mBlock.mPrefix.contains(TD.Prefix.STORAGE_BASED))) {
            for (int i = 0; i < this.mBlock.mMaterialList.length; ++i) {
                if (!this.mBlock.mPrefix.isGeneratingItem(this.mBlock.mMaterialList[i]) || !CS.SHOW_HIDDEN_MATERIALS && this.mBlock.mMaterialList[i].mHidden) continue;
                ItemStack tStack = ST.make((Item)this, 1L, (long)i);
                this.updateItemStack(tStack);
                if (ST.meta_(tStack) != i) continue;
                aList.add(tStack);
            }
        }
        if (aList.isEmpty()) {
            ST.hide((Item)this);
        }
    }

    public boolean placeBlockAt(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float hitX, float hitY, float hitZ, int aMeta) {
        if (this.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)aSide, ST.meta_(aStack), aStack.getTagCompound(), true, false)) {
            if (aWorld.getBlock(aX, aY, aZ) == this.field_150939_a) {
                this.field_150939_a.onBlockPlacedBy(aWorld, aX, aY, aZ, (EntityLivingBase)aPlayer, aStack);
                this.field_150939_a.onPostBlockPlaced(aWorld, aX, aY, aZ, (int)ST.meta_(aStack));
            }
            return true;
        }
        UT.Entities.sendchat((Object)aPlayer, "Cannot place Block in this Environment!");
        return false;
    }

    public int getColorFromItemStack(ItemStack aStack, int aRenderPass) {
        short aMetaData;
        if (aRenderPass == 0 && UT.Code.exists(aMetaData = ST.meta_(aStack), this.mBlock.mMaterialList)) {
            return UT.Code.getRGBInt(this.mBlock.mMaterialList[aMetaData].mRGBa[this.mBlock.mPrefix.mState]);
        }
        return 0xFFFFFF;
    }

    public final String getUnlocalizedName(ItemStack aStack) {
        short aMetaData = ST.meta_(aStack);
        if (aMetaData == Short.MAX_VALUE) {
            return this.mBlock.mNameInternal + "." + Short.MAX_VALUE;
        }
        if (UT.Code.exists(aMetaData, this.mBlock.mMaterialList)) {
            return "oredict." + this.mBlock.mPrefix.dat(this.mBlock.mMaterialList[aMetaData]).toString();
        }
        return this.mBlock.getUnlocalizedName();
    }

    public void addInformation(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        super.addInformation(aStack, aPlayer, aList, aF3_H);
        if (this.mBlock.mSpawnProof) {
            aList.add(LH.Chat.CYAN + LH.get("gt.lang.spawnproof"));
        }
        if (MD.GC.mLoaded) {
            if (this.mBlock.mPrefix == OP.blockSolid) {
                aList.add(LH.Chat.GREEN + LH.get("gt.lang.sealable.any"));
            } else if (this.mBlock.isOpaqueCube()) {
                aList.add(LH.Chat.ORANGE + LH.get("gt.lang.sealable.bug"));
            }
        }
        if (this.mBlock.mGravity) {
            aList.add(LH.Chat.ORANGE + LH.get("gt.lang.gravity"));
        }
        OreDictMaterial aMaterial = this.mBlock.getMetaMaterial(this.getDamage(aStack));
        aList.add(LH.getToolTipBlastResistance(this.field_150939_a, this.mBlock.mBaseResistance * (float)(1 + this.mBlock.getHarvestLevel(aMaterial == null ? (byte)0 : aMaterial.mToolQuality))));
        while (aList.remove(null)) {
        }
    }

    @Override
    public OreDictItemData getOreDictItemData(ItemStack aStack) {
        if (this.mBlock.mPrefix != null && UT.Code.exists(ST.meta_(aStack), this.mBlock.mMaterialList)) {
            return new OreDictItemData(this.mBlock.mPrefix, this.mBlock.mMaterialList[ST.meta_(aStack)]);
        }
        return null;
    }

    @Override
    public void updateItemStack(ItemStack aStack, World aWorld, int aX, int aY, int aZ) {
        this.updateItemStack(aStack);
    }

    @Override
    public void updateItemStack(ItemStack aStack) {
        if (this.mBlock.mMaterialList != OreDictMaterial.MATERIAL_ARRAY) {
            return;
        }
        short aMeta = ST.meta_(aStack);
        if (UT.Code.exists(aMeta, this.mBlock.mMaterialList)) {
            OreDictMaterial aMaterial = this.mBlock.mMaterialList[aMeta];
            if (aMeta != aMaterial.mTargetRegistration.mID) {
                ST.meta_(aStack, aMaterial.mTargetRegistration.mID);
            }
        }
    }

    @Optional.Method(modid="Botania")
    public Block getBlockToPlaceByFlower(ItemStack aStack, SubTileEntity aFlower, int aX, int aY, int aZ) {
        return null;
    }

    @Optional.Method(modid="Botania")
    public void onBlockPlacedByFlower(ItemStack aStack, SubTileEntity aFlower, int aX, int aY, int aZ) {
    }

    public final String getUnlocalizedName() {
        return this.mBlock.getUnlocalizedName();
    }

    public String getItemStackDisplayName(ItemStack aStack) {
        return StatCollector.translateToLocal((String)this.getUnlocalizedName(aStack));
    }

    public final boolean hasContainerItem(ItemStack aStack) {
        return this.getContainerItem(aStack) != null;
    }

    public ItemStack getContainerItem(ItemStack aStack) {
        return null;
    }

    public boolean doesContainerItemLeaveCraftingGrid(ItemStack aStack) {
        return false;
    }

    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        this.updateItemStack(aStack);
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public boolean getIsRepairable(ItemStack aStack, ItemStack aMaterial) {
        return false;
    }

    public int getItemEnchantability() {
        return 0;
    }

    public int getItemStackLimit(ItemStack aStack) {
        return this.mBlock.mPrefix.mDefaultStackSize;
    }

    @Override
    public OreDictMaterial getMaterial(int aMetaData) {
        return UT.Code.exists(aMetaData, this.mBlock.mMaterialList) ? this.mBlock.mMaterialList[aMetaData] : null;
    }

    @Override
    public OreDictPrefix getPrefix(int aMetaData) {
        return this.mBlock.mPrefix;
    }
}

