/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.misc;

import cpw.mods.fml.common.Optional;
import gregapi.block.IBlockBase;
import gregapi.block.ItemBlockBase;
import gregapi.compat.galacticraft.IBlockSealable;
import gregapi.data.CS;
import gregapi.data.MD;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock;
import mods.railcraft.common.carts.EntityTunnelBore;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.IGrowable;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(iface="micdoodle8.mods.galacticraft.api.block.IOxygenReliantBlock", modid="GalacticraftCore")})
public abstract class BlockBaseFlower
extends BlockFlower
implements IBlockBase,
IBlockSealable,
IOxygenReliantBlock,
IGrowable {
    public final String mNameInternal;
    public IIconContainer[] mIcons;
    private final byte mMaxMeta;

    public BlockBaseFlower(Class<? extends ItemBlockBase> aItemClass, String aNameInternal, long aMaxMeta, IIconContainer[] aIcons) {
        super(0);
        this.mMaxMeta = (byte)(UT.Code.bind4(aMaxMeta - 1L) + 1);
        this.mIcons = aIcons;
        this.setStepSound(soundTypeGrass);
        this.mNameInternal = aNameInternal;
        this.setBlockName(this.mNameInternal);
        this.setCreativeTab(CreativeTabs.tabDecorations);
        ST.register((Block)this, this.mNameInternal, aItemClass);
        if (MD.RC.mLoaded) {
            try {
                EntityTunnelBore.addMineableBlock((Block)this);
            }
            catch (Throwable e) {
                e.printStackTrace(CS.ERR);
            }
        }
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("forester", ST.make((Block)this, 1L, 32767L));
        }
    }

    public final String getUnlocalizedName() {
        return this.mNameInternal;
    }

    @Override
    public String name(byte aMeta) {
        return this.mNameInternal + "." + aMeta;
    }

    public String getLocalizedName() {
        return StatCollector.translateToLocal((String)this.mNameInternal);
    }

    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return 0.0f;
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return 0.0f;
    }

    public float getExplosionResistance(Entity aEntity) {
        return 0.0f;
    }

    public String getHarvestTool(int aMeta) {
        return "sword";
    }

    public int getHarvestLevel(int aMeta) {
        return 0;
    }

    public boolean canSilkHarvest() {
        return this.canSilkHarvest((byte)0);
    }

    public boolean canSilkHarvest(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        return this.canSilkHarvest(UT.Code.bind4(aMeta));
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return true;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return false;
    }

    public int damageDropped(int aMeta) {
        return aMeta;
    }

    public int quantityDropped(Random par1Random) {
        return 1;
    }

    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public int getLightOpacity() {
        return 0;
    }

    public Item getItemDropped(int par1, Random aRandom, int par3) {
        return Item.getItemFromBlock((Block)this);
    }

    public Item getItem(World aWorld, int aX, int aY, int aZ) {
        return Item.getItemFromBlock((Block)this);
    }

    public void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public void getSubBlocks(Item aItem, CreativeTabs aTab, List aList) {
        for (int i = 0; i < this.maxMeta(); ++i) {
            aList.add(ST.make(aItem, 1L, (long)i));
        }
    }

    public boolean isSealed(World aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return false;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public byte maxMeta() {
        return this.mMaxMeta;
    }

    public IIcon getIcon(int aSide, int aMeta) {
        return this.mIcons[aMeta % this.mIcons.length].getIcon(0);
    }

    public void onOxygenAdded(World aWorld, int aX, int aY, int aZ) {
    }

    public void onOxygenRemoved(World aWorld, int aX, int aY, int aZ) {
        if (!aWorld.isRemote && !WD.oxygen(aWorld, aX, aY, aZ)) {
            aWorld.setBlock(aX, aY, aZ, CS.NB, 0, 3);
            return;
        }
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 0.0f;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return false;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public boolean isFlammable(byte aMeta) {
        return this.getFlammability(aMeta) > 0;
    }

    @Override
    public boolean isFireSource(byte aMeta) {
        return false;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return 64;
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return aStack;
    }

    public EnumPlantType getPlantType(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return WD.meta(aWorld, aX, aY, aZ);
    }

    public boolean canBlockStay(World aWorld, int aX, int aY, int aZ) {
        return WD.oxygen(aWorld, aX, aY, aZ) && aWorld.getBlock(aX, aY - 1, aZ).canSustainPlant((IBlockAccess)aWorld, aX, aY - 1, aZ, ForgeDirection.UP, (IPlantable)Blocks.yellow_flower);
    }

    public boolean func_149851_a(World aWorld, int aX, int aY, int aZ, boolean aIsRemote) {
        return true;
    }

    public boolean func_149852_a(World aWorld, Random aRandom, int aX, int aY, int aZ) {
        return true;
    }

    public void func_149853_b(World aWorld, Random aRandom, int aX, int aY, int aZ) {
        ST.drop(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (Block)this, 1L, (long)WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public void checkAndDropBlock(World aWorld, int aX, int aY, int aZ) {
        if (this.canBlockStay(aWorld, aX, aY, aZ)) {
            return;
        }
        this.dropBlockAsItem(aWorld, aX, aY, aZ, WD.meta((IBlockAccess)aWorld, aX, aY, aZ), 0);
        aWorld.setBlock(aX, aY, aZ, CS.NB, 0, 2);
    }

    @Override
    public boolean onItemUseFirst(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aStack.stackSize == 0) {
            return false;
        }
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (tTileEntity instanceof TileEntityFlowerPot) {
            if (((TileEntityFlowerPot)tTileEntity).getFlowerPotItem() == null) {
                ((TileEntityFlowerPot)tTileEntity).func_145964_a((Item)aItem, (int)ST.meta(aStack));
                tTileEntity.markDirty();
                if (!aWorld.setBlockMetadataWithNotify(aX, aY, aZ, (int)ST.meta(aStack), 2)) {
                    aWorld.markBlockForUpdate(aX, aY, aZ);
                }
                if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                    --aStack.stackSize;
                }
            }
            return true;
        }
        if (tBlock == Blocks.snow_layer && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (tBlock != Blocks.vine && tBlock != Blocks.tallgrass && tBlock != Blocks.deadbush && !tBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aX += CS.OFFX[aSide];
            aY += CS.OFFY[aSide];
            aZ += CS.OFFZ[aSide];
        }
        if (!aPlayer.canPlayerEdit(aX, aY, aZ, aSide, aStack) || aY == 255 && this.getMaterial().isSolid() || !aWorld.canPlaceEntityOnSide((Block)this, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack)) {
            return false;
        }
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, this.onBlockPlaced(aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, aItem.getMetadata(aStack.getItemDamage())))) {
            aWorld.playSoundEffect((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.stepSound.func_150496_b(), (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.stackSize;
            }
        }
        return true;
    }
}

