/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block;

import gregapi.block.IBlockBase;
import gregapi.block.ItemBlockBase;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockBase
extends Block
implements IBlockBase {
    public final String mNameInternal;

    public BlockBase(Class<? extends ItemBlock> aItemClass, String aNameInternal, Material aMaterial, Block.SoundType aSoundType) {
        super(aMaterial);
        this.setStepSound(aSoundType);
        this.mNameInternal = aNameInternal;
        this.setBlockName(this.mNameInternal);
        this.setCreativeTab(CreativeTabs.tabBlock);
        ST.register(this, this.mNameInternal, aItemClass);
        LH.add(this.mNameInternal + "." + Short.MAX_VALUE, "Any Sub-Block of this one");
    }

    public final String getUnlocalizedName() {
        return this.mNameInternal;
    }

    public String getLocalizedName() {
        return StatCollector.translateToLocal((String)this.mNameInternal);
    }

    public String getHarvestTool(int aMeta) {
        return "pickaxe";
    }

    public int getHarvestLevel(int aMeta) {
        return 0;
    }

    public boolean canSilkHarvest() {
        return this.canSilkHarvest((byte)0);
    }

    public boolean canSilkHarvest(World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ, int aMeta) {
        return this.canSilkHarvest(UT.Code.bind4(aMeta));
    }

    public boolean isToolEffective(String aType, int aMeta) {
        return this.getHarvestTool(aMeta).equals(aType);
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return true;
    }

    public boolean renderAsNormalBlock() {
        return true;
    }

    public boolean isOpaqueCube() {
        return true;
    }

    public boolean func_149730_j() {
        return this.isOpaqueCube();
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aDirection) {
        return this.isSideSolid(WD.meta(aWorld, aX, aY, aZ), UT.Code.side(aDirection));
    }

    public boolean shouldSideBeRendered(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.isOpaqueCube() ? !WD.visOpq(aWorld.getBlock(aX, aY, aZ)) : super.shouldSideBeRendered(aWorld, aX, aY, aZ, aSide);
    }

    public int damageDropped(int aMeta) {
        return aMeta;
    }

    public int quantityDropped(int aMeta, int aFortune, Random aRandom) {
        return 1;
    }

    public ItemStack createStackedBlock(int aMeta) {
        return ST.make(this, 1L, (long)this.damageDropped(aMeta));
    }

    public int getDamageValue(World aWorld, int aX, int aY, int aZ) {
        return WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
    }

    public int getLightOpacity() {
        return 255;
    }

    public Item getItemDropped(int aMeta, Random aRandom, int aFortune) {
        return Item.getItemFromBlock((Block)this);
    }

    public Item getItem(World aWorld, int aX, int aY, int aZ) {
        return Item.getItemFromBlock((Block)this);
    }

    public void registerBlockIcons(IIconRegister aIconRegister) {
    }

    public boolean canSustainPlant(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide, IPlantable aPlant) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        byte aMeta = WD.meta(aWorld, aX, aY, aZ);
        return this.canCreatureSpawn(aMeta) && this.isSideSolid(aMeta, (byte)1);
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.isFireSource(WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.isFlammable(WD.meta(aWorld, aX, aY, aZ));
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.getFlammability(WD.meta(aWorld, aX, aY, aZ));
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide) {
        return this.getFireSpreadSpeed(WD.meta(aWorld, aX, aY, aZ));
    }

    public float getExplosionResistance(Entity aEntity, World aWorld, int aX, int aY, int aZ, double eX, double eY, double eZ) {
        return this.getExplosionResistance(WD.meta((IBlockAccess)aWorld, aX, aY, aZ));
    }

    public float getExplosionResistance(Entity aEntity) {
        return this.getExplosionResistance((byte)0);
    }

    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return 1.0f;
    }

    @Override
    public Block getBlock() {
        return this;
    }

    @Override
    public byte maxMeta() {
        return 1;
    }

    public final void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (this.useGravity(WD.meta((IBlockAccess)aWorld, aX, aY, aZ))) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2);
        }
        this.onNeighborBlockChange2(aWorld, aX, aY, aZ, aBlock);
    }

    public final void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
        if (this.useGravity(WD.meta((IBlockAccess)aWorld, aX, aY, aZ))) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 2);
        }
        this.onBlockAdded2(aWorld, aX, aY, aZ);
    }

    public IIcon getIcon(IBlockAccess aWorld, int aX, int aY, int aZ, int aSide) {
        return this.getIcon(aSide, WD.meta(aWorld, aX, aY, aZ));
    }

    @Override
    public String name(byte aMeta) {
        return aMeta == Short.MAX_VALUE ? this.mNameInternal : this.mNameInternal + "." + aMeta;
    }

    @Override
    public boolean useGravity(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesWalkSpeed(byte aMeta) {
        return false;
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return false;
    }

    @Override
    public boolean canSilkHarvest(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return this.isSideSolid(aMeta, aSide);
    }

    @Override
    public boolean isFireSource(byte aMeta) {
        return false;
    }

    @Override
    public boolean isFlammable(byte aMeta) {
        return this.getFlammability(aMeta) > 0;
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return 10.0f;
    }

    @Override
    public int getFlammability(byte aMeta) {
        return 0;
    }

    @Override
    public int getFireSpreadSpeed(byte aMeta) {
        return 0;
    }

    @Override
    public int getItemStackLimit(ItemStack aStack) {
        return UT.Code.bindStack(OP.block.mDefaultStackSize);
    }

    @Override
    public ItemStack onItemRightClick(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        return aStack;
    }

    public boolean checkNoEntityCollision(World aWorld, int aX, int aY, int aZ, byte aMeta, Entity aExceptThisOne) {
        return aWorld.checkNoEntityCollision(AxisAlignedBB.getBoundingBox((double)aX, (double)aY, (double)aZ, (double)(aX + 1), (double)(aY + 1), (double)(aZ + 1)), aExceptThisOne);
    }

    public boolean isSideSolid(int aMeta, byte aSide) {
        return true;
    }

    public void updateTick2(World aWorld, int aX, int aY, int aZ, Random aRandom) {
    }

    public void onNeighborBlockChange2(World aWorld, int aX, int aY, int aZ, Block aBlock) {
    }

    public void onBlockAdded2(World aWorld, int aX, int aY, int aZ) {
    }

    public final void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        if (aWorld.isRemote || this.checkGravity(aWorld, aX, aY, aZ)) {
            return;
        }
        this.updateTick2(aWorld, aX, aY, aZ, aRandom);
    }

    public boolean checkGravity(World aWorld, int aX, int aY, int aZ) {
        byte aMeta = WD.meta((IBlockAccess)aWorld, aX, aY, aZ);
        if (aY > 0 && this.useGravity(aMeta) && BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ)) {
            if (!BlockFalling.fallInstantly && aWorld.checkChunksExist(aX - 32, aY - 32, aZ - 32, aX + 32, aY + 32, aZ + 32)) {
                if (!aWorld.isRemote) {
                    aWorld.spawnEntityInWorld((Entity)new EntityFallingBlock(aWorld, (double)aX + 0.5, (double)aY + 0.5, (double)aZ + 0.5, (Block)this, (int)aMeta));
                }
            } else {
                aWorld.setBlockToAir(aX, aY, aZ);
                while (BlockFalling.func_149831_e((World)aWorld, (int)aX, (int)(aY - 1), (int)aZ) && aY > 0) {
                    --aY;
                }
                if (aY > 0) {
                    WD.set(aWorld, aX, aY, aZ, (Block)this, (long)aMeta, 2L);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean onItemUse(ItemBlockBase aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int aSide, float aHitX, float aHitY, float aHitZ) {
        if (aStack.stackSize == 0) {
            return false;
        }
        Block tBlock = aWorld.getBlock(aX, aY, aZ);
        if (tBlock == Blocks.snow_layer && (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) & 7) < 1) {
            aSide = 1;
        } else if (tBlock != Blocks.vine && tBlock != Blocks.tallgrass && tBlock != Blocks.deadbush && !tBlock.isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            aX += CS.OFFX[aSide];
            aY += CS.OFFY[aSide];
            aZ += CS.OFFZ[aSide];
        }
        if (!aWorld.getBlock(aX, aY, aZ).isReplaceable((IBlockAccess)aWorld, aX, aY, aZ)) {
            return false;
        }
        if (!this.canReplace(aWorld, aX, aY, aZ, aSide, aStack)) {
            return false;
        }
        byte aMeta = UT.Code.bind4(aItem.getMetadata(ST.meta(aStack)));
        if (!this.checkNoEntityCollision(aWorld, aX, aY, aZ, aMeta, null)) {
            return false;
        }
        if (!aPlayer.canPlayerEdit(aX, aY, aZ, aSide, aStack) || aY == 255 && this.getMaterial().isSolid() || !aWorld.canPlaceEntityOnSide((Block)this, aX, aY, aZ, false, aSide, (Entity)aPlayer, aStack)) {
            return false;
        }
        if (aItem.placeBlockAt(aStack, aPlayer, aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, this.onBlockPlaced(aWorld, aX, aY, aZ, aSide, aHitX, aHitY, aHitZ, aMeta))) {
            aWorld.playSoundEffect((double)((float)aX + 0.5f), (double)((float)aY + 0.5f), (double)((float)aZ + 0.5f), this.stepSound.func_150496_b(), (this.stepSound.getVolume() + 1.0f) / 2.0f, this.stepSound.getPitch() * 0.8f);
            --aStack.stackSize;
        }
        return true;
    }

    public final int quantityDropped(Random aRandom) {
        return this.quantityDropped(0, 0, aRandom);
    }
}

